import { z } from "zod";


export const SignInFormValidation = z.object({

    email: z.string().email("Invalid email address"),
    password: z
      .string()
      .min(8, "password must be at least 8 characters")
      .max(16, "password must be at most 15 characters"),
  
  });


  export const VerifyFormValidation = z.object({
    otp: z.string(),
  });




