import { Instagram, MapPin, Phone } from "lucide-react";
import Link from "next/link";

export default function Footer() {



  return (

    <>

    <footer className="text-white py-8 px-6"
      style={{
        backgroundImage: "linear-gradient(179deg, rgb(10, 112, 227) 0.46%, rgb(3, 78, 162) 87.03%)"
      }}
    >
      <div className="container mx-auto">

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">

          {/* Company Information */}
          <div className="space-y-4">
            <p className="text-sm leading-relaxed" style={{fontSize: 16}}>
              KIGALI PHONES KT is an online market located in Nyarugenge. We are currently shipping in Kigali city.
            </p>
            <div className="flex items-start gap-2">
              <MapPin className="h-5 w-5 mt-0.5 flex-shrink-0" />
              <span className="text-sm">Makuza Peace Plaza, Kigali, Rwanda</span>
            </div>
          </div>

          {/* Quick Links */}
          <div className="space-y-4">
            <h3 className="text-lg font-semibold">Quick Links</h3>
            <nav className="space-y-2">
              <Link href="/" className="block text-sm hover:text-cyan-100 transition-colors">
                Home
              </Link>
              <Link href="/cart" className="block text-sm hover:text-cyan-100 transition-colors">
                Shopping Cart
              </Link>
            </nav>
          </div>

          {/* Social Media */}
          <div className="space-y-4">
            <h3 className="text-lg font-semibold">Social Medias</h3>
            <div className="space-y-3">
              <div className="flex items-center gap-2">
                <Phone className="h-4 w-4" />
                <span className="text-sm">+250 788 889 611</span>
              </div>

              
              <div className="flex items-center gap-2">
                <Link target="blank" href="https://www.instagram.com/kigaliphones_kt/" className="flex items-center gap-2">
                  <Instagram className="h-4 w-4" />
                  <span className="text-sm">Kigaliphoneskt</span>
                </Link>
              </div>

            </div>
          </div>
        </div>
      </div>
    </footer>

      <div className="fixed bottom-6 right-6 z-50">
        <Link
          target="blank"
          href="https://wa.me/250788889611"
          className="flex items-center gap-2 bg-green-500 text-white px-4 py-3 rounded-full shadow-lg hover:bg-green-600 transition-colors"
        >
          <svg
            xmlns="http://www.w3.org/2000/svg"
            width="24"
            height="24"
            viewBox="0 0 24 24"
            fill="none"
            stroke="currentColor"
            strokeWidth="2"
            strokeLinecap="round"
            strokeLinejoin="round"
            className="lucide lucide-message-circle"
          >
            <path d="M7.9 20A9 9 0 1 0 4 16.1L2 22Z" />
          </svg>
          <span>Chat with us</span>
        </Link>
      </div>

    </>

  )

}
      